<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\widgets\FileInput;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model backend\models\Sik */
/* @var $form yii\widgets\ActiveForm */
$model->created_at = ($model->created_at) ? $model->created_at : time();
?>

<div class="sik-form">

    <?php $form = ActiveForm::begin(); ?>

    <i>Upload Your daily keys from .csv file, or copy/paste them to textarea below<br>
    Strings must be formatted as date;string;signature\n\r</i><br><br>
    <?= $form->field($model, 'csvcontent')->textarea(['rows' => 6]) ?>

    
	    <?=FileInput::widget([
	        'name' => 'file',
	        'options' => [
	            'multiple' => true, 
	            'id' => 'scvFileLoad'
	        ],
	        'pluginOptions' => [
	            'allowedFileExtensions' => ['csv'],
	            'previewFileType' => 'any', 
	            'showUpload' => false, 
	            'showRemove' => false, 
	            'initialPreviewAsData' => true, 
	            'overwriteInitial' => true,
	            "uploadUrl" => Url::to(['/upload']),
	            'msgUploadBegin' => '',
	            'msgUploadThreshold' => '',
	            'msgProgress' => '',
	            'msgLoading' => '',
	            'msgPendingTime' => '',
	            'msgCalculatingTime' => '',
	            'msgUploadEnd' => 'Done',
	            'dropZoneClickTitle'=>'',
	            "uploadAsync" => true,
	            "browseOnZoneClick"=>false,
	            'showPreview' => false,
	            'showUploadStats' => false,
	            'showCancel' => false,
	            'fileActionSettings' => [
	                'showZoom' => false,
	                'showRemove' => false,
	                'showUpload' => false,
	            ],
	            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
	        ],
	        'pluginEvents' => [
	            'filebatchselected' => 'function() {
	             $(this).fileinput("upload");
	             }',

	        ],
	    ]);
	    ?>
    

	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
